/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.browser;

import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.browser.BrowserNode;
import ibm.nways.jdm.browser.BrowserQuery;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;

public class BrowserFolder
extends NavigationFolder {
    private static ResourceBundle myResources = null;
    private BrowserNode myNode;
    private boolean expanded = false;
    private SnmpContextModel model;
    private BrowserQuery service;
    private JdmBrowser appl;
    private static final String PROPNAME = "BrowserChild.browser.jdm.nways.ibm";
    private static final String SERVNAME = "BrowserService.browser.jdm.nways.ibm";

    public BrowserFolder(BrowserNode browserNode, BrowserQuery browserQuery, SnmpContextModel snmpContextModel, JdmBrowser jdmBrowser) {
        super(String.valueOf(browserNode.getName()) + " (" + browserNode.id + ")", new NavigationDestination("ibm.nways.jdm.NilDestination", snmpContextModel));
        this.model = snmpContextModel;
        this.myNode = browserNode;
        this.service = browserQuery;
        this.appl = jdmBrowser;
    }

    public void setIsInitiallyExpanded(boolean bl) {
        this.expanded = bl;
        super.setIsInitiallyExpanded(bl);
    }

    public void expand() {
        if (!this.expanded) {
            this.setIsInitiallyExpanded(true);
            if (this.myNode != null) {
                if (this.myNode.children != null) {
                    Object object;
                    Object object2;
                    int n = 0;
                    int n2 = this.myNode.children.size();
                    BrowserNode[] browserNodeArray = new BrowserNode[n2];
                    Enumeration enumeration = this.myNode.children.elements();
                    while (enumeration.hasMoreElements()) {
                        object2 = new Object[]{new Integer(n2 - n)};
                        this.displayMsg(MessageFormat.format(this.getNLSString("metadataStart"), object2));
                        object = (OID)enumeration.nextElement();
                        try {
                            browserNodeArray[n] = this.service.getNode(((OID)object).toString());
                        }
                        catch (RemoteException remoteException) {
                            System.out.println(remoteException);
                            remoteException.printStackTrace();
                        }
                        ++n;
                    }
                    this.displayMsg(this.getNLSString("metadataEnd"));
                    this.displayMsg(this.getNLSString("sortStart"));
                    BrowserNode.QuickSort(browserNodeArray, 0, n2 - 1);
                    this.displayMsg(this.getNLSString("sortEnd"));
                    this.displayMsg(this.getNLSString("folderAdditionStart"));
                    n = 0;
                    while (n < n2) {
                        if (browserNodeArray[n] != null) {
                            if (browserNodeArray[n].item) {
                                object2 = new String(String.valueOf(browserNodeArray[n].getName()) + " (" + browserNodeArray[n].id + ")");
                                NavigationItem navigationItem = new NavigationItem((String)object2, new NavigationDestination("ibm.nways.jdm.browser.BrowserPanel", this.model), "Browser");
                                object = navigationItem.getNavContext();
                                ((NavigationContext)object).put(PROPNAME, browserNodeArray[n]);
                                ((NavigationContext)object).put(SERVNAME, this.service);
                                this.add(navigationItem);
                            } else {
                                BrowserFolder browserFolder = new BrowserFolder(browserNodeArray[n], this.service, this.model, this.appl);
                                if (browserNodeArray[n].oid.value.length > 4) {
                                    browserFolder.setIsInitiallyExpanded(false);
                                }
                                this.add(browserFolder);
                                if (browserNodeArray[n].oid.value.length <= 4) {
                                    browserFolder.expand();
                                }
                            }
                        }
                        ++n;
                    }
                    this.displayMsg(this.getNLSString("folderAdditionEnd"));
                    return;
                }
                System.out.println("Folder node has no children");
                return;
            }
            System.out.println("Folder node is null");
        }
    }

    protected void displayMsg(String string) {
        if (this.appl != null) {
            this.appl.displayMsg(string);
            return;
        }
        System.out.println("Null appl in BrowserFolder");
    }

    private String getNLSString(String string) {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm.browser.BrowserPanelResources", Locale.getDefault());
            }
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }
}

